import { ManualNameBase } from './ManualNameBase.entity';
import { StringIdNameDescWise } from '../interfaces/wises';
import { EntityDescription } from '../decorators/extended';
import { SelectQueryBuilder } from 'typeorm';
import { applyQueryPropertySearch } from '../utility/query';

export class ManualNameDescBase
  extends ManualNameBase
  implements StringIdNameDescWise
{
  @EntityDescription()
  desc: string;

  override applyQuery(
    qb: SelectQueryBuilder<ManualNameDescBase>,
    entityName: string,
  ) {
    super.applyQuery(qb, entityName);
    applyQueryPropertySearch(this, qb, entityName, 'desc');
  }
}
