import { IdNameDescBase } from './IdNameDescBase.entity';
import { StringColumn } from '../decorators/base';
import { SelectQueryBuilder } from 'typeorm';
import { applyQueryPropertyLike } from '../utility/query';

export class AvatarBase extends IdNameDescBase {
  @StringColumn(128, '图标地址', undefined, false)
  avatarUrl: string;

  override applyQuery(qb: SelectQueryBuilder<AvatarBase>, entityName: string) {
    super.applyQuery(qb, entityName);
    applyQueryPropertyLike(this, qb, entityName, 'avatarUrl');
  }
}
