import { IsInt, IsPositive } from 'class-validator';
import { SelectQueryBuilder } from 'typeorm';
import { ApiProperty } from '@nestjs/swagger';
import { NotWritable } from '../entities/decorators/transform';

export class PageSettingsDto {
  @NotWritable()
  @IsPositive()
  @IsInt()
  @ApiProperty({ description: '第 n 页，从 1 开始', required: false })
  pageCount: number;

  @NotWritable()
  @IsPositive()
  @IsInt()
  @ApiProperty({ description: '每页显示的数量', required: false })
  recordsPerPage: number;

  private getRecordsPerPage() {
    return this.recordsPerPage || 25;
  }

  private getStartingFrom() {
    return ((this.pageCount || 1) - 1) * this.getRecordsPerPage();
  }

  applyQuery(qb: SelectQueryBuilder<PageSettingsDto>, entityName: string) {
    qb.take(this.getRecordsPerPage()).skip(this.getStartingFrom());
  }
}
