import { CreateDateColumn, DeleteDateColumn, UpdateDateColumn } from 'typeorm';
import { Exclude } from 'class-transformer';
import { PageSettingsDto } from '../../dto/PageSettings.dto';

export interface DeletionWise {
  deleteTime?: Date;
}

export class TimeBase extends PageSettingsDto implements DeletionWise {
  @CreateDateColumn({ select: false })
  @Exclude()
  createTime: Date;

  @UpdateDateColumn({ select: false })
  @Exclude()
  updateTime: Date;

  @DeleteDateColumn({ select: false })
  @Exclude()
  deleteTime: Date;

  toObject() {
    return JSON.parse(JSON.stringify(this));
  }
}
