import { ManualIdBase } from './ManualIdBase.entity';
import { StringIdNameWise } from '../interfaces/wises';
import { EntityName } from '../decorators/extended';
import { SelectQueryBuilder } from 'typeorm';
import { applyQueryPropertyLike } from '../utility/query';

export class ManualNameBase extends ManualIdBase implements StringIdNameWise {
  @EntityName()
  name: string;
  applyQuery(qb: SelectQueryBuilder<ManualNameBase>, entityName: string) {
    super.applyQuery(qb, entityName);
    applyQueryPropertyLike(this, qb, entityName, 'name');
  }
}
