import { IdBase } from './IdBase.entity';
import { IdNameWise } from '../interfaces/wises';
import { EntityName } from '../decorators/extended';
import { SelectQueryBuilder } from 'typeorm';
import { applyQueryPropertyLike } from '../utility/query';

export class IdNameBase extends IdBase implements IdNameWise {
  @EntityName()
  name: string;

  applyQuery(qb: SelectQueryBuilder<IdNameBase>, entityName: string) {
    super.applyQuery(qb, entityName);
    applyQueryPropertyLike(this, qb, entityName, 'name');
  }
}
