import { IsInt, IsOptional, IsPositive } from 'class-validator';
import { SelectQueryBuilder } from 'typeorm';
import { ApiProperty } from '@nestjs/swagger';

export class PageSettingsDto {
  @IsOptional()
  @IsPositive()
  @IsInt()
  @ApiProperty({ description: '第 n 页，从 1 开始' })
  pageCount: number;

  @IsOptional()
  @IsPositive()
  @IsInt()
  @ApiProperty({ description: '每页显示的数量' })
  recordsPerPage: number;

  private getRecordsPerPage() {
    return this.recordsPerPage || 25;
  }

  private getStartingFrom() {
    return ((this.pageCount || 1) - 1) * this.getRecordsPerPage();
  }

  applyQuery(qb: SelectQueryBuilder<PageSettingsDto>, entityName: string) {
    qb.take(this.getRecordsPerPage()).skip(this.getStartingFrom());
  }
}
