import { Column } from 'typeorm';
import { MergePropertyDecorators } from './base';
import { ApiProperty } from '@nestjs/swagger';
import { IsNotEmpty, IsOptional, IsPositive } from 'class-validator';
import { BigintTransformer } from '../utility/bigint-transform';

export const RelationColumn = (description = '对应编号', notNull = false) =>
  MergePropertyDecorators([
    Column('bigint', {
      nullable: !notNull,
      unsigned: true,
      transformer: new BigintTransformer(),
    }),
    ApiProperty({ type: Number, description }),
    ...(notNull ? [] : [IsOptional()]),
    IsPositive(),
  ]);
export const StringRelationColumn = (
  description = '对应编号',
  notNull = false,
) =>
  MergePropertyDecorators([
    Column('varchar', { length: 32, nullable: !notNull }),
    ApiProperty({ type: String, description }),
    ...(notNull ? [] : [IsOptional()]),
    IsNotEmpty(),
  ]);
