import { DeletionBase } from './DeletionBase.entity';
import { Column, Generated, SelectQueryBuilder } from 'typeorm';
import { IdWise } from '../interfaces/wises';
import { ApiProperty } from '@nestjs/swagger';
import { applyQueryProperty } from '../utility/query';
import { NotWritable } from '../decorators/transform';
import { IsInt, IsPositive } from 'class-validator';
import { BigintTransformer } from '../utility/bigint-transform';

export class IdBase extends DeletionBase implements IdWise {
  @Generated('increment')
  @Column('bigint', {
    primary: true,
    unsigned: true,
    transformer: new BigintTransformer(),
  })
  @ApiProperty({ description: '编号', required: false })
  @NotWritable()
  @IsInt()
  @IsPositive()
  id: number;

  applyQuery(qb: SelectQueryBuilder<IdBase>, entityName: string) {
    super.applyQuery(qb, entityName);
    qb.orderBy(`${entityName}.id`, 'DESC');
    applyQueryProperty(this, qb, entityName, 'id');
  }
}
