import {
  Column,
  Entity,
  JoinColumn,
  ManyToOne,
  OneToMany,
  SelectQueryBuilder,
} from 'typeorm';
import { ApiProperty } from '@nestjs/swagger';
import { Exclude, Expose } from 'class-transformer';
import { ManualNameDescBase } from './bases/ManualNameDescBase.entity';
import { EnumColumn } from './decorators/base';
import { RelationColumn, StringRelationColumn } from './decorators/relation';
import { IsNotEmpty, IsOptional, IsPositive } from 'class-validator';
import { QueryWise } from './interfaces/QueryWise';
import { applyQueryProperty } from './utility/query';

export enum UserRole {
  Admin = 'admin',
  Student = 'student',
  teacher = 'teacher',
}

@Entity()
export class User extends ManualNameDescBase implements QueryWise<User> {
  applyQuery(qb: SelectQueryBuilder<User>, entityName: string) {
    super.applyQuery(qb, entityName);
  }
}
