import { IsInt, IsOptional, IsPositive } from 'class-validator';
import { SelectQueryBuilder } from 'typeorm';

export class PageSettingsDto {
  @IsOptional()
  @IsPositive()
  @IsInt()
  pageCount: number;

  @IsOptional()
  @IsPositive()
  @IsInt()
  recordsPerPage: number;

  private getRecordsPerPage() {
    return this.recordsPerPage || 25;
  }

  private getStartingFrom() {
    return ((this.pageCount || 1) - 1) * this.getRecordsPerPage();
  }

  applyQuery(qb: SelectQueryBuilder<PageSettingsDto>, entityName: string) {
    qb.take(this.getRecordsPerPage()).skip(this.getStartingFrom());
  }
}
