import { loginVCSA, vCenter } from "ts-vcenter";
import yaml from "yaml";
import fs from "fs";

export interface Plan {
	host: string;
	folder: string;
	datastore: string;
	template: string;
}

export class Config {
	username: string;
	url: string;
	password: string;
	plans: Plan[];
	vc: vCenter;
	async load() {
		const config = yaml.parse(await fs.promises.readFile("./config.yaml", "utf-8"));
		for (let field of ["username", "password", "url", "plans"]) {
			this[field] = config[field];
		}
		const token = await loginVCSA(this);
		this.vc = new vCenter({
			url: this.url,
			token
		});
	}
}
