import { Config, Plan } from "./config";
import { vCenter } from "ts-vcenter";

export async function getIP(vcsa: vCenter, filter: any) {
	const [vm] = await vcsa.getVMs(filter);
	const vmInfo = await vcsa.getGuestInfo(vm.vm);
	return vmInfo.ip_address;
}

export async function createVM(vcsa: vCenter, name: string, plan: Plan) {
	const [Libraries] = await Promise.all([vcsa.getContentLibrarys()]);
	const template = Libraries.find(({ items }) => items.find(({ name }) => name === plan.template)).items.find(
		({ name }) => name === plan.template,
	);
	const [hosts, Datastores, Folders] = await Promise.all([
		vcsa.getHosts(),
		vcsa.getDataStores(),
		vcsa.getFolders(),
	]);
	//console.error(`Fetching templates..`);
	//const Template = await vcsa.getVMTemplate(_template.id);
	const {host} = hosts.find(({ name }) => name === plan.host);
	const {folder} = Folders.find(({ type, name }) => type === 'VIRTUAL_MACHINE' && name === plan.folder);
	const { datastore } = Datastores.find(({ name }) => name === plan.datastore);
	console.error(`VM would be deployed to ${JSON.stringify({host, folder, datastore, template: template.id})}`);
	await vcsa.depoyVMTemplate(template.id, {
		placement: { host, folder },
		name,
		powered_on: true,
		disk_storage: { datastore },
		vm_home_storage: { datastore },
	});
}

/* async function main() {
	const config = new Config();
	await config.load();
	const ip = await getIP(config.vc, {
		names: process.argv[2],
		power: "POWERED_ON"
	});
	console.log(ip);
}
main();
*/
