import { Config } from "./src/config";
import { getIP, createVM } from "./src/actions";

async function main() {
	const config = new Config();
	console.error(`Logining into vCenter...`);
	await config.load();
	const vmName = process.argv[3];
	switch (process.argv[2]) {
		case "ip": {
			console.error(`Fetching IP address of ${vmName}.`)
			const ip = await getIP(config.vc, {
				names: vmName
			});
			console.log(ip);
			break;
		}
		case "create": {
			const plan = config.plans[Math.floor(Math.random() * config.plans.length)];
			console.error(`Creating VM with name ${vmName} info ${JSON.stringify(plan)}`);
			await createVM(config.vc, vmName, plan);
			console.error(`Done.`);
			break;
		}
	}
}
main();
