import fs from "fs";
import yaml from "yaml";

export interface Group {
	name: string,
	description: string,
	allowedIPs: string[],
	sets: Set[]
}
export interface Set {
	name: string,
	description: string,
	allowedIPs: string[],
	setname: string,
	here: boolean
}

export interface SSLOptions {
	cert: string,
	key: string
}

export interface Config {
	address: string,
	port: number,
	ssl: SSLOptions,
	trustedProxies: string[]
	title: string,
	groups: Group[]
}

export async function loadConfig(): Promise<Config> {
	const content: string = await fs.promises.readFile("./config.yaml", "utf-8");
	const config: Config = yaml.parse(content);
	return config;
}
