import { IsString } from 'class-validator';
import { ApiProperty } from '@nestjs/swagger';

export class MirrorDto {
  @IsString()
  @ApiProperty({ description: '文件标识路径。' })
  path: string;

  @IsString()
  @ApiProperty({ description: '文件地址，middleware 曾经返回的。' })
  url: string;

  @IsString()
  @ApiProperty({ description: 'middleware 标识符' })
  middleware: string;
}
