import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { HttpModule } from '@nestjs/axios';
import { UtilityModule } from './utility/utility.module';
import { JsdModule } from './jsd/jsd.module';
import { OneTwoThreeModule } from './one-two-three/one-two-three.module';

@Module({
  imports: [
    ConfigModule.forRoot({ isGlobal: true }),
    {
      ...HttpModule.register({}),
      global: true,
    },
    UtilityModule,
    JsdModule,
    OneTwoThreeModule,
  ],
})
export class AppModule {}
