import { Body, Get, Ip, Patch, Post, ValidationPipe } from '@nestjs/common';
import {
  ApiBody,
  ApiCreatedResponse,
  ApiOkResponse,
  ApiOperation,
} from '@nestjs/swagger';
import {
  MiddlewareInfoReturnMessageDto,
  ReturnMessageDto,
  StringReturnMessageDto,
} from '../dto/ReturnMessage.dto';
import { PostUrlDto } from '../dto/PostUrl.dto';
import { MiddlewareService } from './service';
import { MirrorDto } from '../dto/Mirror.dto';

export class MiddlewareController {
  constructor(protected middlewareService: MiddlewareService) {}

  @Get()
  @ApiOperation({ summary: '中间件信息' })
  @ApiOkResponse({ type: MiddlewareInfoReturnMessageDto })
  async jsdInfo() {
    return new ReturnMessageDto(
      200,
      'success',
      await this.middlewareService.info(),
    );
  }

  @Post()
  @ApiOperation({ summary: '上传中间件文件' })
  @ApiBody({ type: PostUrlDto })
  @ApiCreatedResponse({ type: StringReturnMessageDto })
  async upload(
    @Body(new ValidationPipe({ transform: true })) urlDto: PostUrlDto,
  ) {
    return new ReturnMessageDto(
      201,
      'success',
      await this.middlewareService.upload(urlDto),
    );
  }

  @Patch()
  @ApiOperation({ summary: '获取文件下载地址' })
  @ApiBody({ type: MirrorDto })
  @ApiOkResponse({ type: StringReturnMessageDto })
  async download(
    @Body(new ValidationPipe({ transform: true })) mirrorDto: MirrorDto,
    @Ip() ip: string,
  ) {
    return new ReturnMessageDto(
      200,
      'success',
      await this.middlewareService.download(mirrorDto, ip),
    );
  }
}
