import { Injectable } from '@nestjs/common';
import { lastValueFrom } from 'rxjs';
import internal from 'stream';
import { BlankReturnMessageDto } from '../../dto/ReturnMessage.dto';
import { HttpService } from '@nestjs/axios';

@Injectable()
export class UtilityService {
  constructor(private http: HttpService) {}

  async getStreamFromUrl(url: string) {
    try {
      return await lastValueFrom(
        await this.http.get<internal.Readable>(url, {
          responseType: 'stream',
          timeout: 30000,
          maxBodyLength: 4 * 1024 ** 3,
          maxContentLength: 4 * 1024 ** 3,
        }),
      );
    } catch (e) {
      throw new BlankReturnMessageDto(404, 'URL not available').toException();
    }
  }
}
