import { IsNotEmpty, IsUrl } from 'class-validator';
import { ApiProperty } from '@nestjs/swagger';
import hasha from 'hasha';

export class PostUrlDto {
  @ApiProperty({ description: '源 URL' })
  @IsNotEmpty()
  @IsUrl()
  url: string;

  @ApiProperty({ description: '可能的文件大小' })
  size?: number;

  @ApiProperty({ description: '自定义后缀' })
  customSuffix?: string;

  @ApiProperty({ description: '自定义 MIME' })
  customMime?: string;

  getFilename() {
    const urlHash = hasha(this.url, { algorithm: 'sha256' });
    if (this.customSuffix) {
      return `${this.url}.${this.customSuffix}`;
    }
    const lastPattern = this.url.split('/').pop();
    if (!lastPattern.length) {
      return urlHash;
    }
    const dotSplit = lastPattern.split('.');
    if (dotSplit.length <= 1) {
      return urlHash;
    }
    return `${urlHash}.${dotSplit.slice(1).join('.')}`;
  }
}
