import { Body, Controller, Get, Post, ValidationPipe } from '@nestjs/common';
import { AppService } from './app.service';
import {
  ApiBody,
  ApiCreatedResponse,
  ApiOkResponse,
  ApiOperation,
} from '@nestjs/swagger';
import { PostUrlDto } from './dto/PostUrl.dto';
import {
  MiddlewareInfoReturnMessageDto,
  StringReturnMessageDto,
} from './dto/ReturnMessage.dto';

@Controller()
export class AppController {
  constructor(private readonly appService: AppService) {}

  @Get('jsd')
  @ApiOperation({ summary: 'JSDelivr', description: '需要配置 JSD_URL' })
  @ApiOkResponse({ type: MiddlewareInfoReturnMessageDto })
  jsdInfo() {
    return this.appService.jsdInfo();
  }

  @Post('jsd')
  @ApiOperation({ summary: 'JSDelivr', description: '需要配置 JSD_URL' })
  @ApiBody({ type: PostUrlDto })
  @ApiCreatedResponse({ type: StringReturnMessageDto })
  jsd(@Body(new ValidationPipe({ transform: true })) urlDto: PostUrlDto) {
    return this.appService.jsd(urlDto);
  }
}
