import axios from 'axios';
import fs from 'fs';
import _ from 'lodash';

let current = parseInt(process.env.CURRENT || '0', 36);
const max = parseInt(process.env.MAX || 'ZZZZZ', 36);
const parallel = parseInt(process.env.PARALLEL) || 10;

const useCode = async (n: number) => {
  let code = n.toString(36).toUpperCase();
  if (code.length < 5) {
    code = '0'.repeat(5 - code.length) + code;
  }
  console.log(`Trying ${code}`);
  try {
    const result = await axios.get(`http://www.clco.cc/${code}`, {
      responseType: 'text',
      validateStatus: (c) => c < 400 || c === 404,
      timeout: parseInt(process.env.TIMEOUT) || 10000,
    });
    if (result.status === 404) {
      console.log(`Bad ${code}`);
    } else {
      const data = {
        status: result.status,
        headers: result.headers,
        data: result.data,
      };
      console.log(`Good ${code}: ${JSON.stringify(data)}`);
      await fs.promises.writeFile(
        `data/${n}-${code}.json`,
        JSON.stringify(data, null, 2),
      );
    }
  } catch (e) {
    console.error(`Failed ${code}: ${e.message}`);
  }
};

async function main() {
  while (current <= max) {
    const start = current;
    const end = Math.min(current + parallel, max + 1);
    console.log(`Running ${start} - ${end - 1}`);
    const ranges = _.range(start, end);
    await Promise.all(ranges.map(useCode));
    current = end;
  }
}
main();
