import os
from model import answer
from flask import Flask, request

app = Flask(__name__)

accessToken = os.environ.get("ACCESS_TOKEN")

def makeResponse(statusCode, message, data):
    return { 'success': statusCode < 400, 'statusCode': statusCode, 'message': message, 'data': data }, statusCode

@app.route('/', methods = ['POST'])
def conversation():
  if accessToken and request.headers.get("Authorization") != "Bearer " + accessToken:
    return makeResponse(403, "Access denied", None)
  prompt = request.json
  if not prompt or 'text' not in prompt:
    return makeResponse(400, 'Empty text')
  result = answer(prompt['text'])
  return makeResponse(200, 'success', { 'text': result })
