import yaml from 'yaml';
import * as fs from 'fs';
import { DatasourceConfig } from '../datasource/datasource';

export interface OpenAIAccount {
  email: string;
  password: string;
  loginType: 'default' | 'google' | 'microsoft';
  pro: boolean;
}

const defaultConfig = {
  host: '::',
  port: 3000,
  accounts: {
    type: 'static',
    config: [],
  } as DatasourceConfig<OpenAIAccount[]>,
  redisUrl: '',
  token: '',
  proxies: {
    type: 'static',
    config: [],
  } as DatasourceConfig<string[]>,
  apiKeys: {
    type: 'static',
    config: [],
  } as DatasourceConfig<string[]>,
};

export type Config = typeof defaultConfig;

export async function loadConfig(): Promise<Config> {
  let readConfig: Partial<Config> = {};
  try {
    const configText = await fs.promises.readFile('./config.yaml', 'utf-8');
    readConfig = yaml.parse(configText);
  } catch (e) {
    console.error(`Failed to read config: ${e.toString()}`);
  }
  return {
    ...defaultConfig,
    ...readConfig,
    ...process.env,
  };
}
