import { Injectable } from '@nestjs/common';
import { ProxyProviderService } from '../proxy-provider/proxy-provider.service';

@Injectable()
export class ProxyPoolService {
  private pointer = 0;
  constructor(private proxyProvider: ProxyProviderService) {}

  async getProxy() {
    const proxies = await this.proxyProvider.get();
    if (!proxies?.length) {
      return;
    }
    if (this.pointer >= proxies.length) {
      this.pointer = 0;
    }
    return proxies[this.pointer++];
  }
}
