import { NestFactory } from '@nestjs/core';
import { DocumentBuilder, SwaggerModule } from '@nestjs/swagger';
import { NestExpressApplication } from '@nestjs/platform-express';
import { AppModule } from './app.module';
import { ConfigService } from '@nestjs/config';

async function bootstrap() {
  const app = await NestFactory.create<NestExpressApplication>(AppModule);
  app.setGlobalPrefix('api');
  app.enableCors();
  app.set('trust proxy', ['172.16.0.0/12', 'loopback']);

  const documentConfig = new DocumentBuilder()
    .setTitle('chatgpt-forwarder')
    .setDescription('Forwards ChatGPT messages to an API.')
    .setVersion('1.0')
    .build();

  const document = SwaggerModule.createDocument(app, documentConfig);
  SwaggerModule.setup('docs', app, document);

  const config = app.get(ConfigService);
  await app.listen(
    config.get<number>('port') || 3000,
    config.get<string>('host') || '::',
  );
}
bootstrap();
