import { ConsoleLogger, Injectable, OnModuleInit } from '@nestjs/common';
import { KeyProviderService } from '../key-provider/key-provider.service';
import { ChatGPTAPI, ChatMessage } from 'chatgpt5';
import { BlankReturnMessageDto } from '../dto/ReturnMessage.dto';

@Injectable()
export class DavinciService extends ConsoleLogger implements OnModuleInit {
  constructor(private keyProvider: KeyProviderService) {
    super('Davinci');
  }

  private ChatGPTApiConstructor: typeof ChatGPTAPI;

  async onModuleInit() {
    const { ChatGPTAPI } = await eval("import('chatgpt5')");
    this.ChatGPTApiConstructor = ChatGPTAPI;
  }

  private _isAvailable = false;
  async isAvailable() {
    if (this._isAvailable) return true;
    const keys = await this.keyProvider.get();
    if (!keys.length) return false;
    this._isAvailable = true;
    return true;
  }

  private pointer = 0;
  private async getKey(exclude: string[] = []) {
    const excludeSet = new Set(exclude);
    const keys = (await this.keyProvider.get()).filter(
      (key) => !excludeSet.has(key),
    );
    if (!keys.length) {
      throw new BlankReturnMessageDto(
        500,
        'No available accounts.',
      ).toException();
    }
    if (this.pointer >= keys.length) {
      this.pointer = 0;
    }
    const index = this.pointer++;
    return keys[index];
  }

  getInstance(apiKey: string) {
    return new this.ChatGPTApiConstructor({
      apiKey,
      completionParams: {
        model: 'gpt-3.5-turbo',
      },
      getMessageById: async () => undefined,
      upsertMessage: async () => undefined,
    });
  }

  async chat(text: string, excludeKeys: string[] = []): Promise<ChatMessage> {
    const key = await this.getKey(excludeKeys);
    const api = this.getInstance(key);
    try {
      return await api.sendMessage(text);
    } catch (e) {
      this.error(`Error with key ${key}}`);
      this.error(e);
      return this.chat(text, [...excludeKeys, key]);
    } finally {
      // clean off the message store
      await api['_messageStore'].disconnect();
      delete api['_messageStore'];
    }
  }
}
