import { BaseDatasource } from '../base';
import * as fs from 'fs';

export class FileDatasource<T> extends BaseDatasource<T, 'file'> {
  async getData() {
    const content = await fs.promises.readFile(this.config.path, 'utf-8');
    return content
      .split('\n')
      .map((_line) => {
        const line = _line.trim();
        if (!line) {
          return '';
        }
        if (!this.config.separator) {
          return line;
        }
        const values = line.split(new RegExp(this.config.separator));
        if (!this.config.keys) {
          return values;
        }
        const obj: Record<string, string> = {};
        this.config.keys.forEach((key, index) => {
          obj[key] = values[index];
        });
        return obj;
      })
      .filter((d) => !!d);
  }
}
