import { BaseDatasource } from '../base';
import axios from 'axios';

export class ApiDatasource<T> extends BaseDatasource<T, 'api'> {
  async getData() {
    const { endpoint, headers } = this.config;
    const res = await axios.get(endpoint, { headers });
    return res.data;
  }
}
