import { StaticDatasource } from './source/static';
import { ApiDatasource } from './source/api';
import { BaseDatasource } from './base';
import { FileDatasource } from './source/file';

export interface DatasourceConfigMap<T> {
  static: T;
  api: { endpoint: string; headers: Record<string, string | number> };
  file: { path: string; keys: string[]; separator: string };
}
export interface DatasourceConfig<
  T,
  K extends keyof DatasourceConfigMap<T> = keyof DatasourceConfigMap<T>,
> {
  type: K;
  config: DatasourceConfigMap<T>[K];
}

export const Datasources = new Map<
  string,
  new <T, K extends keyof DatasourceConfigMap<T>>(
    config: DatasourceConfigMap<T>[K],
  ) => BaseDatasource<T, K>
>();

Datasources.set('static', StaticDatasource as any);
Datasources.set('api', ApiDatasource as any);
Datasources.set('file', FileDatasource as any);
