import { ConfigService } from '@nestjs/config';
import { DatasourceConfig, Datasources } from './datasource';

export class BaseProvider<T> {
  constructor(protected config: ConfigService, protected key: string) {}

  async get(): Promise<T> {
    const config = this.config.get<DatasourceConfig<T>>(this.key);
    if (!config) {
      return;
    }
    if (Array.isArray(config)) {
      // legacy config
      return config as T;
    }
    const Datasource = Datasources.get(config.type);
    if (!Datasource) {
      throw new Error(`Unknown datasource type: ${config.type}`);
    }
    return new Datasource(config.config).getData();
  }
}
