import { Injectable } from '@nestjs/common';
import { InjectAragami } from 'nestjs-aragami';
import { Aragami } from 'aragami';
import { ConversationStorage } from './conversation.dto';
import type { ChatResponse } from 'chatgpt3';

@Injectable()
export class ConversationService {
  constructor(@InjectAragami() private readonly aragami: Aragami) {}

  async hasConversation(session: string) {
    return this.aragami.has(ConversationStorage, session);
  }

  async getConversation(session: string) {
    return this.aragami.get(ConversationStorage, session);
  }

  async saveConversation(
    session: string,
    response: ChatResponse,
    account: string,
  ) {
    return this.aragami.set(ConversationStorage, {
      session,
      conversationId: response.conversationId,
      messageId: response.messageId,
      account,
    });
  }

  async resetConversation(session: string) {
    return this.aragami.del(ConversationStorage, session);
  }
}
