import { CacheKey, CacheTTL } from 'aragami';
import { ApiProperty } from '@nestjs/swagger';

export class ConversationBase {
  @CacheKey()
  @ApiProperty({ description: 'Session identifier.' })
  session: string;
}

export class HasConversationDto extends ConversationBase {
  @ApiProperty({ description: 'Whether the session has a conversation.' })
  hasConversation: boolean;
}

export class ConversationDto extends ConversationBase {
  @ApiProperty({ description: 'Message from ChatGPT.' })
  text: string;

  @ApiProperty({ description: 'Whether the conversation is newly created.' })
  isNewConversation: boolean;
}

@CacheTTL(7200000)
export class ConversationStorage extends ConversationBase {
  account: string;

  conversationId: string;

  messageId: string;
}
