import { ApiProperty } from '@nestjs/swagger';
import { IsNotEmpty, IsOptional, IsString } from 'class-validator';

export class TalkDto {
  @IsOptional()
  @IsString()
  @ApiProperty({ description: 'Session identifier.', required: false })
  session: string;

  @IsString()
  @IsNotEmpty()
  @ApiProperty({ description: 'Message from user.' })
  text: string;
}
