import { Injectable } from '@nestjs/common';
import { ConfigService } from '@nestjs/config';
import { BlankReturnMessageDto } from '../dto/ReturnMessage.dto';

@Injectable()
export class AuthService {
  constructor(private config: ConfigService) {}

  async auth(header: string) {
    const token = this.config.get<string>('token');
    if (!token) {
      return true;
    }
    if (!header) {
      throw new BlankReturnMessageDto(401, 'Token required').toException();
    }
    if (header.startsWith('Bearer ')) {
      header = header.slice(7);
    }
    if (header !== token) {
      throw new BlankReturnMessageDto(403, 'Invalid token').toException();
    }
    return true;
  }
}
