import { Module } from '@nestjs/common';
import { AppController } from './app.controller';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { loadConfig } from './utility/config';
import { AragamiModule } from 'nestjs-aragami';
import { ChatgptService } from './chatgpt/chatgpt.service';
import { ConversationService } from './conversation/conversation.service';
import { AuthService } from './auth/auth.service';
import { ProxyPoolService } from './proxy-pool/proxy-pool.service';
import { AccountPoolService } from './account-pool/account-pool.service';
import { AccountProviderService } from './account-provider/account-provider.service';
import { ProxyProviderService } from './proxy-provider/proxy-provider.service';
import { KeyProviderService } from './key-provider/key-provider.service';
import { DavinciService } from './davinci/davinci.service';
import { ScheduleModule } from '@nestjs/schedule';

@Module({
  imports: [
    ConfigModule.forRoot({
      load: [loadConfig],
      isGlobal: true,
      ignoreEnvVars: true,
      ignoreEnvFile: true,
    }),
    AragamiModule.registerAsync({
      inject: [ConfigService],
      useFactory: (config: ConfigService) => {
        const redisUrl = config.get<string>('redisUrl');
        if (redisUrl) {
          return {
            redis: {
              uri: redisUrl,
            },
          };
        }
        return {};
      },
    }),
    ScheduleModule.forRoot(),
  ],
  controllers: [AppController],
  providers: [
    ChatgptService,
    ConversationService,
    AuthService,
    ProxyPoolService,
    AccountPoolService,
    AccountProviderService,
    ProxyProviderService,
    KeyProviderService,
    DavinciService,
  ],
})
export class AppModule {}
