import yaml from 'yaml';
import * as fs from 'fs';

const defaultConfig = {
  host: '::',
  port: 3000,
  OPENAI_EMAIL: '',
  OPENAI_PASSWORD: '',
  REDIS_URL: '',
  OPENAI_LOGIN_TYPE: 'default',
  OPENAI_PRO: false,
};

export type Config = typeof defaultConfig;

export async function loadConfig(): Promise<Config> {
  let readConfig: Partial<Config> = {};
  try {
    const configText = await fs.promises.readFile('./config.yaml', 'utf-8');
    readConfig = yaml.parse(configText);
  } catch (e) {
    console.error(`Failed to read config: ${e.toString()}`);
  }
  return {
    ...defaultConfig,
    ...readConfig,
    ...process.env,
  };
}
