import { Injectable } from '@nestjs/common';
import { InjectAragami } from 'nestjs-aragami';
import { Aragami } from 'aragami';
import { ConversationDto } from './conversation.dto';
import type { ChatResponse } from 'chatgpt3';

@Injectable()
export class ConversationService {
  constructor(@InjectAragami() private readonly aragami: Aragami) {}

  async getConversation(session: string) {
    return this.aragami.get(ConversationDto, session);
  }

  async saveConversation(session: string, response: ChatResponse) {
    return this.aragami.set(ConversationDto, {
      session,
      conversationId: response.conversationId,
      messageId: response.messageId,
    });
  }

  async resetConversation(session: string) {
    return this.aragami.del(ConversationDto, session);
  }
}
