import { Module } from '@nestjs/common';
import { AppController } from './app.controller';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { loadConfig } from './utility/config';
import { AragamiModule } from 'nestjs-aragami';
import { ChatgptService } from './chatgpt/chatgpt.service';
import { ConversationService } from './conversation/conversation.service';
import { AuthService } from './auth/auth.service';

@Module({
  imports: [
    ConfigModule.forRoot({
      load: [loadConfig],
      isGlobal: true,
      ignoreEnvVars: true,
      ignoreEnvFile: true,
    }),
    AragamiModule.registerAsync({
      inject: [ConfigService],
      useFactory: (config: ConfigService) => {
        const redisUrl = config.get<string>('REDIS_URL');
        if (redisUrl) {
          return {
            redis: {
              uri: redisUrl,
            },
          };
        }
        return {};
      },
    }),
  ],
  controllers: [AppController],
  providers: [ChatgptService, ConversationService, AuthService],
})
export class AppModule {}
