import {
  Body,
  Controller,
  Header,
  Headers,
  Post,
  ValidationPipe,
} from '@nestjs/common';
import { ChatgptService } from './chatgpt/chatgpt.service';
import {
  BlankReturnMessageDto,
  ReturnMessageDto,
} from './dto/ReturnMessage.dto';
import { ConversationDto } from './conversation/conversation.dto';
import {
  ApiBody,
  ApiCreatedResponse,
  ApiHeader,
  ApiOperation,
} from '@nestjs/swagger';
import { TalkDto } from './chatgpt/talk.dto';
import { ResetConversationDto } from './conversation/reset-conversation.dto';
import { ConversationService } from './conversation/conversation.service';
import { AuthService } from './auth/auth.service';

const ResponseDto = ReturnMessageDto(ConversationDto);

@ApiHeader({ name: 'Authorization', required: false })
@Controller()
export class AppController {
  constructor(
    private readonly chatgpt: ChatgptService,
    private readonly conversation: ConversationService,
    private readonly authService: AuthService,
  ) {}

  @Post('chat')
  @ApiOperation({ summary: 'Chat with ChatGPT' })
  @ApiBody({ type: TalkDto })
  @ApiCreatedResponse({ type: ResponseDto })
  async chat(
    @Body(
      new ValidationPipe({
        transform: true,
        transformOptions: { enableImplicitConversion: true },
      }),
    )
    dto: TalkDto,
    @Headers('Authorization') header: string,
  ) {
    await this.authService.auth(header);
    return new ResponseDto(201, 'success', await this.chatgpt.chat(dto));
  }

  @Post('reset-conversation')
  @ApiOperation({ summary: 'Reset conversation' })
  @ApiBody({ type: ResetConversationDto })
  @ApiCreatedResponse({ type: BlankReturnMessageDto })
  async resetConversation(
    @Body(
      new ValidationPipe({
        transform: true,
        transformOptions: { enableImplicitConversion: true },
      }),
    )
    dto: ResetConversationDto,
    @Headers('Authorization') header: string,
  ) {
    await this.authService.auth(header);
    await this.conversation.resetConversation(dto.session);
    return new BlankReturnMessageDto(201, 'success');
  }
}
