import express from 'express';
import cookieParser from 'cookie-parser';
import logger from 'morgan';
import config from './config';
import { Avatar } from './avatar';

const app = express();

app.use(logger(config.loggerLevel));
app.use(express.json());
app.use(express.urlencoded({ extended: false }));
app.use(cookieParser());

app.get('/healthcheck', (req, res, next) => {
  res.status(200).send('OK');
});

const avatar = new Avatar();
avatar.init();

app.get('/user_avatar/ygobbs.com/:username/:size/:filename.png', async(req, res, next) => {
  const { username, size, filename } = req.params;
  const parsedSize = parseInt(size);
  if (!parsedSize || parsedSize < 8 || parsedSize > 1000) {
    res.status(400).send("Invalid size.");
  }
  const buffer = await avatar.getImage(username, parsedSize, `${filename}.png`);
  if (buffer) {
    res.status(200).header(
      { 'Content-Type': 'image/png' }
    ).send(buffer);
  } else {
    res.status(404).send(`Avatar not found.`);
  }
});

export default app;
