import { Processor } from "./processor";
import magick from "imagemagick-native-12";
import { CutData } from "./utility";
import cluster from "cluster";
import util from "util";

export default async function worker() {
	const processor = new Processor();
	processor.addHandler("cut", async (cutData: CutData) => {
		try {
			const sourceBuffer = Buffer.from(cutData.image);
			const targetBuffer: Buffer = await magick.promises.convert({
				//srcFormat: "PNG",
				format: "PNG",
				srcData: sourceBuffer,
				width: cutData.size,
				height: cutData.size
			});
			return targetBuffer.toJSON().data;
		} catch (e) {
			console.error(`Worker ${cluster.worker.id}: Error resizing image to ${cutData.size}: ${e.toString()}`);
			return null;
		}
	});
	await processor.ready();
	console.error(`Worker ${cluster.worker.id} is ready.`);
}
