"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const node_fetch_1 = require("node-fetch");
const moment = require("moment");
const FormData = require("form-data");
function formatTime(t) {
    return t.unix();
}
function compressData(jsonData, replays) {
    const headerLengthBuffer = Buffer.alloc(4);
    const headerContentBuffer = Buffer.from(jsonData, "utf8");
    headerLengthBuffer.writeUInt32BE(headerContentBuffer.length);
    let replayBuffer = null;
    for (let i = 0; i < replays.length; i++) {
        const replayData = replays[i];
        const replayDataLengthBuffer = Buffer.alloc(4);
        replayDataLengthBuffer.writeUInt32BE(replayData.length, 0);
        if (!replayBuffer) {
            replayBuffer = Buffer.concat([replayDataLengthBuffer, replayData]);
        }
        else {
            replayBuffer = Buffer.concat([replayBuffer, replayDataLengthBuffer, replayData]);
        }
    }
    if (!replayBuffer) {
        return null;
    }
    return Buffer.concat([headerLengthBuffer, headerContentBuffer, replayBuffer]);
}
function uploadResult(room) {
    try {
        if (!room.finishedAt) {
            room.finishedAt = [];
        }
        room.finishedAt.push(moment());
        const data = {
            roomSettings: Object.assign(Object.assign({}, room.hostinfo), { lflist: Object.assign(Object.assign({}, lflists[room.hostinfo.lflist]), { date: lflists[room.hostinfo.lflist].date.clone().add(1, "day").format("YYYY.MM") }) }),
            players: room.customPlayerInformation || [],
            startedAt: room.startedAt ? room.startedAt.map(formatTime) : [],
            finishedAt: room.finishedAt ? room.finishedAt.map(formatTime) : [],
            type: room.arena || "normal",
            isRandomMatch: Boolean(room.random_type),
            winnerNames: room.winnerNames || [],
            scores: room.scores,
        };
        room.replaySaved = true;
        const compressedData = compressData(JSON.stringify(data), room.replays);
        if (!compressedData) {
            return;
        }
        const formData = new FormData();
        formData.append("data", compressedData, {
            filename: "data.bin",
        });
        (() => __awaiter(this, void 0, void 0, function* () {
            const response = yield (0, node_fetch_1.default)("http://10.198.1.45:3619/replay/upload", {
                method: "POST",
                body: formData,
                headers: formData.getHeaders(),
            });
            if (!response.ok || response.status === 500) {
                throw new Error("Status Code " + response.status);
            }
            const data = (yield response.json());
            if (data.status === 500) {
                throw new Error(data.message);
            }
        }))().catch(e => {
            log.warn(`YGOReplay data collecting plugin error: ${e.message}`);
        });
    }
    catch (e) {
        const err = e;
        log.warn(`YGOReplay: an error occurred during uploading match result: ${err.message}`);
    }
}
ygopro.stoc_follow("DUEL_START", false, (buffer, info, client) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        if (client.pos !== 0) {
            return true;
        }
        const room = ROOM_all[client.rid];
        if (!room || !room.dueling_players || room.hostinfo.mode === 2 || Boolean(room.windbot)) {
            return true;
        }
        if (!room.startedAt) {
            room.startedAt = [];
        }
        room.startedAt.push(moment());
        if (!room.customPlayerInformation) {
            room.customPlayerInformation = room.dueling_players.map(player => {
                return {
                    ip: player.ip,
                    name: player.name,
                    joinTime: moment(player.join_time).format("YYYY-MM-DD HH:mm:ss"),
                    pos: player.pos,
                    lang: player.lang,
                    pass: player.pass,
                    sidedDeck: [
                        {
                            main: player.main,
                            side: player.side,
                        },
                    ],
                };
            });
        }
    }
    catch (e) {
        log.warn(`YGOReplay: an error occurred during processing DUEL_START message: ${e.message}`);
    }
    return true;
}));
ygopro.stoc_follow_after("GAME_MSG", false, (buffer, info, client) => __awaiter(void 0, void 0, void 0, function* () {
    if (buffer.readUInt8(0) === 5 && client.pos === 0) {
        const room = ROOM_all[client.rid];
        if (!room || !room.dueling_players) {
            return false;
        }
        const player = room.dueling_players.find(p => p.name === room.winner_name);
        if (!player) {
            return false;
        }
        if (!room.winnerNames) {
            room.winnerNames = [];
        }
        if (room.winner_name) {
            room.winnerNames.push(room.winner_name);
        }
    }
    return false;
}));
ygopro.stoc_follow_after("CHANGE_SIDE", false, (buffer, info, client) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        client.needToChangeSide = true;
        if (client.pos === 0) {
            return false;
        }
        const room = ROOM_all[client.rid];
        if (!room || Boolean(room.windbot)) {
            return false;
        }
        if (!room.finishedAt) {
            room.finishedAt = [];
        }
        room.finishedAt.push(moment());
    }
    catch (e) {
        log.warn(`YGOReplay: an error occurred during processing CHANGE_SIDE message: ${e.message}`);
    }
    return false;
}));
ygopro.stoc_follow_after("REPLAY", false, (buffer, info, client) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const room = ROOM_all[client.rid];
        if (Boolean(room.windbot)) {
            return true;
        }
        if (client.pos === 0) {
            uploadResult(room);
        }
    }
    catch (e) {
        log.warn(`YGOReplay: an error occurred during processing REPLAY message: ${e.message}`);
    }
    return false;
}));
ygopro.ctos_follow_after("UPDATE_DECK", false, (buffer, info, client) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const room = ROOM_all[client.rid];
        if (!room || Boolean(room.windbot) || !room.dueling_players) {
            return false;
        }
        if (!room.customPlayerInformation) {
            return false;
        }
        const customPlayerInformation = room.customPlayerInformation.find(player => player.pos === client.pos);
        if (!customPlayerInformation) {
            return false;
        }
        const player = room.dueling_players.find(p => p.pos === client.pos);
        if (!player) {
            return false;
        }
        if (client.needToChangeSide) {
            customPlayerInformation.sidedDeck.push({
                main: player.main,
                side: player.side,
            });
            client.needToChangeSide = false;
        }
    }
    catch (e) {
        log.warn(`YGOReplay: an error occurred during processing UPDATE_DECK message: ${e.message}`);
    }
    return false;
}));
(() => {
    const oldSTOCSend = ygopro.stoc_send.bind(ygopro);
    ygopro.stoc_send = (client, message, buffer) => {
        try {
            if (message !== "REPLAY") {
                return oldSTOCSend(client, message, buffer);
            }
            const room = ROOM_all[client.rid];
            if (room && client.pos === 0 && !room.replaySaved && room.customPlayerInformation && !room.windbot) {
                uploadResult(room);
            }
        }
        catch (e) {
            log.warn(`YGOReplay: an error occurred during processing UPDATE_DECK message: ${e.message}`);
        }
        return oldSTOCSend(client, message, buffer);
    };
})();
