os=require("os")
io=require("io")
--globals
local main={[0]={},[1]={}}
local extra={[0]={},[1]={}}

local main_nonadv={[0]={},[1]={}}

local main_monster={[0]={},[1]={}}
local main_spell={[0]={},[1]={}}
local main_trap={[0]={},[1]={}}

local main_plain={[0]={},[1]={}}
local main_adv={[0]={},[1]={}}

local main_new={[0]={},[1]={}}

local extra_sp={
	[TYPE_FUSION]={[0]={},[1]={}},
	[TYPE_SYNCHRO]={[0]={},[1]={}},
	[TYPE_XYZ]={[0]={},[1]={}},
	[TYPE_LINK]={[0]={},[1]={}},
}

local xyz_plain={[0]={},[1]={}}
local xyz_adv={[0]={},[1]={}}

local extra_fixed={62709239,95169481}
local combo_pack=require("./2pick/combo")
local Deepthink=require("./2pick/SkillDeepThink")
--local DrawSense=require("./2pick/SkillDrawSense")
--local ChickenGame=require("./2pick/SkillChickenGame")
--local ActionDuel=require("./2pick/actionduel")

function Auxiliary.SplitData(inputstr)
	local t={}
	for str in string.gmatch(inputstr,"([^|]+)") do
		table.insert(t,tonumber(str))
	end
	return t
end
function Auxiliary.LoadDB(p,pool)
	local file=io.popen("echo .exit | sqlite3 "..pool.." -cmd \"select * from datas;\"")
	for line in file:lines() do
		local data=Auxiliary.SplitData(line)
		if #data<2 then break end
		local code=data[1]
		local ot=data[2]
		local cat=data[5]
		local lv=data[8] & 0xff
		if (cat & TYPE_FUSION+TYPE_SYNCHRO+TYPE_XYZ+TYPE_LINK)>0 then
			table.insert(extra[p],code)
			for tp,list in pairs(extra_sp) do
				if (cat & tp)>0 then
					table.insert(list[p],code)
				end
			end
			if (cat & TYPE_XYZ)>0 then
				if lv>4 then
					table.insert(xyz_adv[p],code)
				else
					table.insert(xyz_plain[p],code)
				end
			end
		elseif (cat & TYPE_TOKEN)==0 then
			if (ot==4) then
				table.insert(main_new[p],code)
			end
			if (cat & TYPE_MONSTER)>0 then
				table.insert(main_monster[p],code)
				if lv>4 then
					table.insert(main_adv[p],code)
				else
					table.insert(main_plain[p],code)
					table.insert(main_nonadv[p],code)
				end
			elseif (cat & TYPE_SPELL)>0 then
				table.insert(main_nonadv[p],code)
				table.insert(main_spell[p],code)
			elseif (cat & TYPE_TRAP)>0 then
				table.insert(main_nonadv[p],code)
				table.insert(main_trap[p],code)
			end
			table.insert(main[p],code)
		end
	end
	file:close()
end
--to do: multi card pools
function Auxiliary.LoadCardPools()
	local pool_list={}
	local file=io.popen("ls 2pick/*.cdb")
	for pool in file:lines() do
		table.insert(pool_list,pool)
	end
	file:close()
	for p=0,1 do
		Auxiliary.LoadDB(p,pool_list[math.random(#pool_list)])
	end
end

function Auxiliary.SaveDeck()
	for p=0,1 do
		local g=Duel.GetFieldGroup(p,0xff,0)
		Duel.SavePickDeck(p,g)
	end
end
function Auxiliary.SinglePick(p,list,count,ex_list,ex_count,copy,lv_diff,fixed,packed,optional)
	if not Duel.IsPlayerNeedToPickDeck(p) then return end
	local g1=Group.CreateGroup()
	local g2=Group.CreateGroup()
	local ag=Group.CreateGroup()
	local plist=list[p]
	local lastpack=-1
	for _,g in ipairs({g1,g2}) do
		--for i=1,count do
		--	local code=plist[math.random(#plist)]
		--	g:AddCard(Duel.CreateToken(p,code))
		--end
		local pick_count=0
		if packed then
			while true do
				local thispack=math.random(#packed)
				if thispack~=lastpack then
					lastpack=thispack
					for _,code in ipairs(packed[thispack]) do
						local card=Duel.CreateToken(p,code)
						g:AddCard(card)
						ag:AddCard(card)
					end
					break
				end
			end
		end
		while pick_count<count do
			local code=plist[math.random(#plist)]
			local lv=Duel.ReadCard(code,CARDDATA_LEVEL)
			if not ag:IsExists(Card.IsCode,1,nil,code) and not (lv_diff and g:IsExists(Card.IsLevel,1,nil,lv)) then
				local card=Duel.CreateToken(p,code)
				g:AddCard(card)
				ag:AddCard(card)
				pick_count=pick_count+1
			end
		end
		if ex_list and ex_count then
			--for i=1,ex_count do
			--	local code=ex_plist[math.random(#ex_plist)]
			--	g:AddCard(Duel.CreateToken(p,code))
			--end
			local ex_plist=ex_list[p]
			local ex_pick_count=0
			while ex_pick_count<ex_count do
				local code=ex_plist[math.random(#ex_plist)]
				local lv=Duel.ReadCard(code,CARDDATA_LEVEL)
				if not ag:IsExists(Card.IsCode,1,nil,code) and not (lv_diff and g:IsExists(Card.IsLevel,1,nil,lv)) then
					local card=Duel.CreateToken(p,code)
					g:AddCard(card)
					ag:AddCard(card)
					ex_pick_count=ex_pick_count+1
				end
			end
		end
		if fixed then
			for _,code in ipairs(fixed) do
				local card=Duel.CreateToken(p,code)
				g:AddCard(card)
				ag:AddCard(card)
			end
		end
		Duel.SendtoDeck(g,nil,0,REASON_RULE)
	end
	Duel.ResetTimeLimit(p,90)
	
	if optional and ag:GetFirst():IsLocation(LOCATION_DECK) then
		Duel.ConfirmCards(p,ag)
		if Duel.SelectOption(p,1190,1192)==1 then
			Duel.Exile(ag,REASON_RULE)
			return false
		end
	end
	
	local tg=Group.CreateGroup()
	local rg=ag
	while true do
		local finish=tg:GetCount()>0
		Duel.Hint(HINT_SELECTMSG,p,HINTMSG_TODECK)
		local sc=rg:SelectUnselect(tg,p,finish,false,#g1,#g2)
		if not sc then break end
		tg=g1:IsContains(sc) and g1 or g2
		rg=g1:IsContains(sc) and g2 or g1
	end
	
	if tg:GetFirst():IsLocation(LOCATION_DECK) then
		Duel.ConfirmCards(p,tg)
	end
	Duel.Exile(rg,REASON_RULE)
	if copy then
		local g3=Group.CreateGroup()
		for nc in aux.Next(tg) do
			local copy_code=nc:GetOriginalCode()
			g3:AddCard(Duel.CreateToken(p,copy_code))
		end
		Duel.SendtoDeck(g3,nil,0,REASON_RULE)
	end
	return true
end
function Auxiliary.ArbitraryPick(p,count,pick_lists,lists_count,copy,lv_diff,fixed)
	if not Duel.IsPlayerNeedToPickDeck(p) then return end
	local ag=Group.CreateGroup()
	local eg=Group.CreateGroup()
	for index,list in pairs(pick_lists) do
		local plist=list[p]
		local pg=Group.CreateGroup()
		local pick_count=lists_count[index]
		while pick_count>0 do
			local code=plist[math.random(#plist)]
			local lv=Duel.ReadCard(code,CARDDATA_LEVEL)
			if not ag:IsExists(Card.IsCode,1,nil,code) and not (lv_diff and pg:IsExists(Card.IsLevel,1,nil,lv)) then
				local card=Duel.CreateToken(p,code)
				ag:AddCard(card)
				pg:AddCard(card)
				pick_count=pick_count-1
			end
		end
	end
	if fixed then
		for _,code in ipairs(fixed) do
			local card=Duel.CreateToken(p,code)
			ag:AddCard(card)
		end
	end
	Duel.SendtoDeck(ag,nil,0,REASON_RULE)
	Duel.ResetTimeLimit(p,120)
	
	Duel.Hint(HINT_SELECTMSG,p,0)
	local tg=ag:Select(p,count,count,nil)
	local rg=ag
	rg:Sub(tg)
	while true do
		local finish=tg:GetCount()==count
		Duel.Hint(HINT_SELECTMSG,p,HINTMSG_TODECK)
		local sc=rg:SelectUnselect(tg,p,finish,false,count,count)
		if not sc then break end
		if tg:IsContains(sc) then
			tg:RemoveCard(sc)
			rg:AddCard(sc)
		else
			tg:AddCard(sc)
			rg:RemoveCard(sc)
		end
	end
	
	if tg:GetFirst():IsLocation(LOCATION_DECK) then
		Duel.ConfirmCards(p,tg)
	end
	Duel.Exile(rg,REASON_RULE)
	if copy then
		local g3=Group.CreateGroup()
		for nc in aux.Next(tg) do
			local copy_code=nc:GetOriginalCode()
			g3:AddCard(Duel.CreateToken(p,copy_code))
		end
		Duel.SendtoDeck(g3,nil,0,REASON_RULE)
	end
end
function Auxiliary.StartPick(e)
	for p=0,1 do
		if Duel.IsPlayerNeedToPickDeck(p) then
			local g=Duel.GetFieldGroup(p,0xff,0)
			Duel.Exile(g,REASON_RULE)
		end
	end
--[[
	for i=1,5 do
		local list=main
		local count=4
		local ex_list=nil
		local ex_count=nil
		if i==1 or i==2 then
			list=main_plain
			count=3
			ex_list=main_adv
			ex_count=1
		elseif i==3 then
			list=main_plain
			--Adding New Cards
			count=3
			ex_list=main_new
			ex_count=1
		elseif i==4 then
			list=main_spell
		elseif i==5 then
			list=main_trap
		end
		for p=0,1 do
			Auxiliary.SinglePick(p,list,count,ex_list,ex_count,false)
		end
	end
]]--

	-- 50% chance reverse pick
	local picktype=Duel.TossDice(0,1)

	if picktype==1 then
		-- main deck
		Auxiliary.MainDeckPick()
		-- combo pick
		Auxiliary.ComboDeckPick()
		-- extra deck pick
		Auxiliary.ExtraDeckPick()
	elseif picktype==2 then
		-- main deck
		Auxiliary.MainDeckPick()
		-- extra deck pick
		Auxiliary.ExtraDeckPick()
		-- combo pick
		Auxiliary.ComboDeckPick()
	elseif picktype==3 then
		-- extra deck pick
		Auxiliary.ExtraDeckPick()
		-- main deck
		Auxiliary.MainDeckPick()
		-- combo pick
		Auxiliary.ComboDeckPick()
	elseif picktype==4 then
		-- extra deck pick
		Auxiliary.ExtraDeckPick()
		-- combo pick
		Auxiliary.ComboDeckPick()
		-- main deck
		Auxiliary.MainDeckPick()
	elseif picktype==5 then
		-- combo pick
		Auxiliary.ComboDeckPick()
		-- main deck
		Auxiliary.MainDeckPick()
		-- extra deck pick
		Auxiliary.ExtraDeckPick()
	else
		-- combo pick
		Auxiliary.ComboDeckPick()
		-- extra deck pick
		Auxiliary.ExtraDeckPick()
		-- main deck
		Auxiliary.MainDeckPick()
	end

--[[
	for i=1,5 do
		local lists={[1]=main_monster,[3]=main_spell,[4]=main_trap}
		local lists_count={[1]=4,[3]=2,[4]=2}
		if i==1 or i==2 then
			lists[1]=main_plain
			lists_count[1]=2
			lists[2]=main_adv
			lists_count[2]=2
		end
		for p=0,1 do
			Auxiliary.ArbitraryPick(p,4,lists,lists_count)
		end
	end
	
	-- combo pick
	for t=2,0,-1 do
		local reroll=t>0
		if Auxiliary.SinglePick(0,main,0,nil,nil,false,false,nil,combo_pack.pack,reroll) then
			break
		end
	end
	for t=1,0,-1 do
		local reroll=t>0
		if Auxiliary.SinglePick(1,main,0,nil,nil,false,false,nil,combo_pack.pack,reroll) then
			break
		end
	end
	
	for tp,list in pairs(extra_sp) do
		if tp~=TYPE_FUSION then
			for p=0,1 do
				lists ={[1]=list}
				counts={[1]=8}
				lv_diff=false
				if tp==TYPE_XYZ then
					lists[1]=xyz_plain
					counts[1]=6
					lists[2]=xyz_adv
					counts[2]=2
				elseif tp==TYPE_SYNCHRO then
					counts[1]=4
					lists[2]=list
					counts[2]=4
					lv_diff=true
				end
				Auxiliary.ArbitraryPick(p,4,lists,counts,false,lv_diff)
			end
		end
	end
	for p=0,1 do
		lists ={[1]=extra}
		counts={[1]=6}
		Auxiliary.ArbitraryPick(p,4,lists,counts,false,false,extra_fixed)
	end
]]--

	-- XXYYZZ Additional Picks
--[[
	xyz_list={91998119,91998120,91998121}
	for p=0,1 do
		if Duel.IsPlayerNeedToPickDeck(p) then
			local ng=Group.CreateGroup()
			local card1=Duel.CreateToken(p,2111707)
			local card2=Duel.CreateToken(p,25119460)
			local card3=Duel.CreateToken(p,99724761)
			local card4=Duel.CreateToken(p,xyz_list[math.random(#xyz_list)])
			ng:AddCard(card1)
			ng:AddCard(card2)
			ng:AddCard(card3)
			ng:AddCard(card4)
			Duel.SendtoDeck(ng,nil,0,REASON_RULE)
		end
	end
]]--

	Auxiliary.SaveDeck()
	--ActionDuel.Load_Action_Duel()

	for p=0,1 do
		if Duel.IsPlayerNeedToPickDeck(p) then
			Duel.ShuffleDeck(p)
			Duel.ResetTimeLimit(p)
		end
	end
	for p=0,1 do
		Duel.Draw(p,Duel.GetStartCount(p),REASON_RULE)
	end
	e:Reset()
end

function Auxiliary.MainDeckPick()
	for i=1,5 do
		local lists={[1]=main_monster,[3]=main_spell,[4]=main_trap}
		local lists_count={[1]=4,[3]=2,[4]=2}
		if i==1 or i==2 then
			lists[1]=main_plain
			lists_count[1]=2
			lists[2]=main_adv
			lists_count[2]=2
		end
		for p=0,1 do
			Auxiliary.ArbitraryPick(p,4,lists,lists_count)
		end
	end
end
function Auxiliary.ExtraDeckPick()
	for tp,list in pairs(extra_sp) do
		if tp~=TYPE_FUSION then
			for p=0,1 do
				local lists ={[1]=list}
				local counts={[1]=8}
				local lv_diff=false
				if tp==TYPE_XYZ then
					lists[1]=xyz_plain
					counts[1]=6
					lists[2]=xyz_adv
					counts[2]=2
				elseif tp==TYPE_SYNCHRO then
					counts[1]=4
					lists[2]=list
					counts[2]=4
					lv_diff=true
				end
				Auxiliary.ArbitraryPick(p,4,lists,counts,false,lv_diff)
			end
		end
	end
	for p=0,1 do
		local lists={[1]=extra}
		local counts={[1]=6}
		Auxiliary.ArbitraryPick(p,4,lists,counts,false,false,extra_fixed)
	end
end
function Auxiliary.ComboDeckPick()
	for t=2,0,-1 do
		local reroll=t>0
		if Auxiliary.SinglePick(0,main,0,nil,nil,false,false,nil,combo_pack.pack,reroll) then
			break
		end
	end
	for t=1,0,-1 do
		local reroll=t>0
		if Auxiliary.SinglePick(1,main,0,nil,nil,false,false,nil,combo_pack.pack,reroll) then
			break
		end
	end
end

function Auxiliary.Load2PickRule()
	math.randomseed(os.time())
	Auxiliary.LoadCardPools()
	local e1=Effect.GlobalEffect()
	e1:SetType(EFFECT_TYPE_FIELD | EFFECT_TYPE_CONTINUOUS)
	e1:SetCode(EVENT_ADJUST)
	e1:SetProperty(EFFECT_FLAG_IGNORE_IMMUNE)
	e1:SetOperation(Auxiliary.StartPick)
	Duel.RegisterEffect(e1,0)

	--Skill Deepthink
	Deepthink.Load_Skill_Deepthink_Rule()

	--Skill DrawSense Specials
	--DrawSense.Load_Skill_DrawSense_Rule()

	--Chicken_Game_Rule
	--ChickenGame.Load_Chicken_Game_Rule()
end
