import {Component, OnInit} from '@angular/core';
import {HttpClient} from "@angular/common/http";
import {YunomiService} from "../api";

interface RecordStorageData {
  filename: string;

  id: string;
}

interface RecordTask extends RecordStorageData {

  replayContent?: string | null;

  status: string;

  downloadLink?: string | null;

  failMessage?: string | null;

  completeTime?: Date | null;

  selected?: boolean;
}

const demoRecordTasks: RecordTask[] = [
  {
    filename: '11111111.ydk',
    id: 'fed54dbc-0133-4025-849c-c6779921dacd',
    status: "finished",
    downloadLink: "https://1.1.1.1",
    failMessage: null,
    completeTime: new Date(),
    selected: false
  },
  {
    filename: '11111112.ydk',
    id: 'fed63dc1-a847-497a-921f-c4850e29f3dd',
    status: "finished",
    downloadLink: "https://1.1.1.1",
    failMessage: null,
    completeTime: null,
    selected: false
  },
  {
    filename: '11111113.ydk',
    id: 'febe681a-2ee2-4b34-88a4-7535601e605c',
    status: "finished",
    downloadLink: "https://1.1.1.1",
    failMessage: null,
    completeTime: null,
    selected: false
  },
  {
    filename: '11111114.ydk',
    id: 'fe954bba-72d1-4213-8ba2-8c53f38f5c6a',
    status: "finished",
    downloadLink: "https://1.1.1.1",
    failMessage: null,
    completeTime: null,
    selected: false
  }
]

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent implements OnInit {
  title = 'Yunomi';
  token = localStorage.getItem("token");
  replays: RecordStorageData[] = [];
  recordTasks: RecordTask[] = [];
  lastSelectedIndex: number | null = null;
  constructor(private yunomiService: YunomiService) {
    const replaysStorageRawData = localStorage.getItem('replays');
    if(replaysStorageRawData) {
      try {
        this.replays = JSON.parse(replaysStorageRawData);
      }catch(e) {}
    }
  }

  ngOnInit(): void {
    this.recordTasks = demoRecordTasks;
  }

  saveReplayData() {
    localStorage.setItem('replays', JSON.stringify(this.replays));
  }

  saveToken() {
    localStorage.setItem('token', this.token || '');
  }

  async testHello() {
    const data = this.yunomiService.appControllerGetTask('ff7e85c5-69ac-4847-9498-fb87fd408e89', this.token!);
    alert(JSON.stringify(await data.toPromise()));
  }

  onSelectRecord(i: number, record: RecordTask, mouseEvent: MouseEvent) {
    const shiftPressed = mouseEvent.shiftKey;
    if(this.lastSelectedIndex == null || !shiftPressed || this.lastSelectedIndex === i) {
      record.selected = !record.selected;
      this.lastSelectedIndex = i;
    } else {
      const targetSelected = this.recordTasks[this.lastSelectedIndex].selected;
      const fromIndex = Math.min(this.lastSelectedIndex, i);
      const toIndex = Math.max(this.lastSelectedIndex, i);
      const recordsToSelect = this.recordTasks.slice(fromIndex, toIndex + 1);
      for(let record of recordsToSelect) {
        record.selected = targetSelected;
      }
    }

  }

  onDownloadSelected() {
    const recordsToDownload = this.recordTasks.filter(r => r.selected);
  }
}
