-- New Races
RACE_CYBORG = 0x2000000
RACE_MAGICALKNIGHT = 0x4000000
RACE_HYDRAGON = 0x8000000
RACE_OMEGAPSYCHO = 0x10000000
RACE_CELESTIALKNIGHT = 0x20000000

-- Base
RushDuel = {}
RD = RushDuel
function RushDuel.CreatePlayerTargetGlobalEffect(code, value)
    local e = Effect.GlobalEffect()
    e:SetType(EFFECT_TYPE_FIELD)
    e:SetCode(code)
    e:SetProperty(EFFECT_FLAG_PLAYER_TARGET)
    e:SetTargetRange(1, 1)
    if value ~= nil then
        e:SetValue(value)
    end
    Duel.RegisterEffect(e, 0)
    return e
end
function RushDuel.CreateFieldGlobalEffect(continuous, code, operation)
    local e = Effect.GlobalEffect()
    if continuous then
        e:SetType(EFFECT_TYPE_FIELD + EFFECT_TYPE_CONTINUOUS)
    else
        e:SetType(EFFECT_TYPE_FIELD)
    end
    e:SetCode(code)
    e:SetOperation(operation)
    Duel.RegisterEffect(e, 0)
    return e
end

-- Initialize
function RushDuel.Init()
    RushDuel.InitRule()
    Duel.BreakEffect = function()
        -- Don't Break Effect
    end
    -- Duel Start
    RushDuel.CreateFieldGlobalEffect(true, EVENT_PHASE_START + PHASE_DRAW, function(e)
        -- Draw 1 For First Hand
        if not Auxiliary.Load2PickRule then
            Duel.Draw(0, 1, REASON_RULE)
        end
        -- Legend Card
        local g = Duel.GetMatchingGroup(Card.IsCode, 0, 0xff, 0xff, nil, 120000000)
        local legend = g:GetFirst()
        while legend do
            RushDuel.InitLegend(legend)
            legend = g:GetNext()
        end
        e:Reset()
    end)
end
function RushDuel.InitRule()
    -- Lock Zone
    RushDuel.CreateFieldGlobalEffect(false, EFFECT_DISABLE_FIELD, function(e, tp)
        return 0x11711171
    end)
    -- Draw Phase
    RushDuel.CreatePlayerTargetGlobalEffect(EFFECT_DRAW_COUNT, function(e)
        return math.max(1, 5 - Duel.GetFieldGroupCount(Duel.GetTurnPlayer(), LOCATION_HAND, 0))
    end)
    -- Standby Phase
    RushDuel.CreatePlayerTargetGlobalEffect(EFFECT_SKIP_SP)
    -- Summon Unlimited
    RushDuel.CreatePlayerTargetGlobalEffect(EFFECT_SET_SUMMON_COUNT_LIMIT, 100)
    -- Once Per Turn
    local function get_effect_owner_code(e)
        if e:GetType() & EFFECT_TYPE_XMATERIAL == EFFECT_TYPE_XMATERIAL then
            -- Maximum L/R Effect
            return e:GetLabel()
        else
            return e:GetOwner():GetCode()
        end
    end
    RushDuel.CreatePlayerTargetGlobalEffect(EFFECT_CANNOT_ACTIVATE, function(e, re, tp)
        return re:GetHandler():GetFlagEffect(get_effect_owner_code(re)) ~= 0
    end)
    RushDuel.CreateFieldGlobalEffect(true, EVENT_CHAIN_SOLVING, function(e, tp, eg, ep, ev, re, r, rp)
        local te = Duel.GetChainInfo(ev, CHAININFO_TRIGGERING_EFFECT)
        local code = get_effect_owner_code(te)
        te:GetHandler():RegisterFlagEffect(code, RESET_EVENT + RESETS_STANDARD + RESET_PHASE + PHASE_END, 0, 1)
    end)
    -- Trap Activate Limit
    local function is_trap(e)
        return e:IsHasType(EFFECT_TYPE_ACTIVATE) and e:IsActiveType(TYPE_TRAP)
    end
    local function tarp_limit(e, rp, tp)
        return not is_trap(e)
    end
    RushDuel.CreateFieldGlobalEffect(true, EVENT_CHAINING, function(e, tp, eg, ep, ev, re, r, rp)
        if is_trap(re) then
            Duel.SetChainLimit(tarp_limit)
        end
    end)
    -- Main Phase 2
    RushDuel.CreatePlayerTargetGlobalEffect(EFFECT_SKIP_M2)
    -- Hand Unlimited
    RushDuel.CreatePlayerTargetGlobalEffect(EFFECT_HAND_LIMIT, 100)
end

-- Legend
function RushDuel.InitLegend(c)
    local e = Effect.GlobalEffect()
    e:SetType(EFFECT_TYPE_SINGLE)
    e:SetCode(EFFECT_ADD_CODE)
    e:SetProperty(EFFECT_FLAG_IGNORE_IMMUNE + EFFECT_FLAG_CANNOT_DISABLE)
    e:SetRange(0xff)
    e:SetValue(c:GetOriginalCode())
    c:RegisterEffect(e)
end
function RushDuel.IsLegendCode(c, ...)
    for _, code in ipairs {...} do
        if c:GetOriginalCode() == code and c:IsCode(120000000) then
            return true
        end
    end
    return false
end

-- Select Effect
function RushDuel.BaseSelectEffect(c, eff1hint, eff1con, eff1op, eff2hint, eff2con, eff2op)
    local e = Effect.CreateEffect(c)
    e:SetType(EFFECT_TYPE_IGNITION)
    e:SetRange(LOCATION_MZONE)
    e:SetTarget(RushDuel.SelectEffectTarget(eff1con, eff2con))
    e:SetOperation(RushDuel.SelectEffectOperation(eff1hint, eff1con, eff1op, eff2hint, eff2con, eff2op))
    return e
end
function RushDuel.SelectEffectCondition(eff1con, eff2con)
    return function(e, tp, eg, ep, ev, re, r, rp)
        return eff1con(e, tp, eg, ep, ev, re, r, rp, false) or eff2con(e, tp, eg, ep, ev, re, r, rp, false)
    end
end
function RushDuel.SelectEffectTarget(eff1con, eff2con)
    return function(e, tp, eg, ep, ev, re, r, rp, chk)
        if chk == 0 then
            return eff1con(e, tp, eg, ep, ev, re, r, rp, false) or eff2con(e, tp, eg, ep, ev, re, r, rp, false)
        end
    end
end
function RushDuel.SelectEffectOperation(eff1hint, eff1con, eff1op, eff2hint, eff2con, eff2op)
    return function(e, tp, eg, ep, ev, re, r, rp)
        local eff1 = eff1con(e, tp, eg, ep, ev, re, r, rp, true)
        local eff2 = eff2con(e, tp, eg, ep, ev, re, r, rp, true)
        local select = 0
        Duel.Hint(HINT_SELECTMSG, tp, HINTMSG_EFFECT)
        if eff1 and eff2 then
            select = Duel.SelectOption(tp, eff1hint, eff2hint) + 1
        elseif eff1 then
            Duel.SelectOption(tp, eff1hint)
            select = 1
        elseif eff2 then
            Duel.SelectOption(tp, eff2hint)
            select = 2
        end
        if select == 1 then
            eff1op(e, tp, eg, ep, ev, re, r, rp)
        elseif select == 2 then
            eff2op(e, tp, eg, ep, ev, re, r, rp)
        end
    end
end

-- Expand

-- Special Summon Count
function RushDuel.GetSPCount(tp, max)
    if Duel.IsPlayerAffectedByEffect(tp, 59822133) then
        max = 1
    end
    local ct = Duel.GetMZoneCount(tp)
    if ct < 1 then
        return 0
    elseif ct > max then
        return max
    else
        return ct
    end
end
