import YGOProDeck from '..';

describe('Constructor deep copy', () => {
  it('should deep copy main/extra/side arrays from plain object', () => {
    const init = {
      main: [1, 2],
      extra: [3],
      side: [4, 5],
    };

    const deck = new YGOProDeck(init);

    expect(deck.main).toStrictEqual([1, 2]);
    expect(deck.extra).toStrictEqual([3]);
    expect(deck.side).toStrictEqual([4, 5]);

    expect(deck.main).not.toBe(init.main);
    expect(deck.extra).not.toBe(init.extra);
    expect(deck.side).not.toBe(init.side);

    init.main.push(99);
    init.extra.push(88);
    init.side.push(77);

    expect(deck.main).toStrictEqual([1, 2]);
    expect(deck.extra).toStrictEqual([3]);
    expect(deck.side).toStrictEqual([4, 5]);

    deck.main.push(66);
    deck.extra.push(55);
    deck.side.push(44);

    expect(init.main).toStrictEqual([1, 2, 99]);
    expect(init.extra).toStrictEqual([3, 88]);
    expect(init.side).toStrictEqual([4, 5, 77]);
  });

  it('should deep copy main/extra/side arrays from another deck', () => {
    const source = new YGOProDeck({
      main: [10],
      extra: [20, 21],
      side: [30],
      name: 'source',
    });

    const deck = new YGOProDeck(source);

    expect(deck.main).toStrictEqual([10]);
    expect(deck.extra).toStrictEqual([20, 21]);
    expect(deck.side).toStrictEqual([30]);

    expect(deck.main).not.toBe(source.main);
    expect(deck.extra).not.toBe(source.extra);
    expect(deck.side).not.toBe(source.side);

    source.main.push(11);
    source.extra.push(22);
    source.side.push(31);

    expect(deck.main).toStrictEqual([10]);
    expect(deck.extra).toStrictEqual([20, 21]);
    expect(deck.side).toStrictEqual([30]);

    deck.main.push(12);
    deck.extra.push(23);
    deck.side.push(32);

    expect(source.main).toStrictEqual([10, 11]);
    expect(source.extra).toStrictEqual([20, 21, 22]);
    expect(source.side).toStrictEqual([30, 31]);
  });
});
