import YGOProDeck from '..';
import * as ydkejs from 'ydke';

describe('YDKE interoperability test', () => {
  const main = [1000, 1000, 1000, 2000, 2000, 3000];
  const extra = [4000, 5000];
  const side = [6000];

  it('should encode with ygopro-deck-encode and decode with ydke.js', () => {
    const deck = new YGOProDeck();
    deck.main = [...main];
    deck.extra = [...extra];
    deck.side = [...side];

    const uri = deck.toYdkeURL();
    const decoded = ydkejs.parseURL(uri);

    expect(Array.from(decoded.main)).toStrictEqual(main);
    expect(Array.from(decoded.extra)).toStrictEqual(extra);
    expect(Array.from(decoded.side)).toStrictEqual(side);
  });

  it('should encode with ydke.js and decode with ygopro-deck-encode', () => {
    const typedDeck: ydkejs.TypedDeck = {
      main: new Uint32Array(main),
      extra: new Uint32Array(extra),
      side: new Uint32Array(side),
    };

    const uri = ydkejs.toURL(typedDeck);
    const decoded = new YGOProDeck().fromYdkeURL(uri);

    expect(decoded.main).toStrictEqual(main);
    expect(decoded.extra).toStrictEqual(extra);
    expect(decoded.side).toStrictEqual(side);
  });
});
