# ygopro-deck-encode

YGOPro Deck encode and decode, with well-browser support.

## Usage

```ts
const deck = new YGOProDeck();
// main: number[]
// extra: number[]
// side: number[]

const code = deck.toEncodedString(); // base64url-encoded deck code
const anotherDeck = YGOProDeck.fromEncodedString(code); // decode it back

const ydk = deck.toYdkString(); // YDK format
const yetAnotherDeck = YGOProDeck.fromYdkString(ydk); // decode it back

const ydke = deck.toYdkeURL();
const yetAnotherDeck2 = YGOProDeck.fromYdkeURL(ydke); // decode it back

const ygomobileDeckUrl = deck.toYGOMobileDeckURL(); // YGOMobile Deck URL
const yetAnotherDeck3 = YGOProDeck.fromYGOMobileDeckURL(ygomobileDeckUrl); // decode it back

const updateDeckPayload = deck.toUpdateDeckPayload(); // payload for MSG_UPDATE_DECK
// decode it back, but a callback is needed for check if it's extra deck
// use SQLite3 is recommended
// by default, it would assume everything is main deck
const yetAnotherDeck4 = YGOProDeck.fromUpdateDeckPayload(updateDeckPayload, (code, i, mainc) => i >= mainc - 15);
```


## Encode format

The deck code is a base64url-encoded string, which is an unsigned 32-bit integer array, each number representing a card

- 28 bits: card ID
- 2 bits: card type
  - 0: main deck
  - 1: extra deck
  - 2: side deck
- 2 bits: card count - 1. a.k.a. 0 means 1, 1 means 2, 2 means 3, 3 means 4
