import Base from "./base";
import axios from "axios";
import { Card } from "./dbreader";

export class CNOCGFetcher extends Base { 
	static async fetchOnce() {
		const fetcher = new CNOCGFetcher({ name: "Temp NW Fetcher" });
		await fetcher.init();
		return await fetcher.fetch();
	}
	async fetch(): Promise<Card[]> {
		this.log.debug(`Started fetching from CNOCG source...`);
		const allCardStrings: string[] = (await axios.get("https://api.tcgcardgame.com/api/cards/sc", {
			responseType: "json"
		})).data;
		const allCards = allCardStrings.map(m => new Card(parseInt(m)));
		return allCards;
	}
}
